/*
 * Decompiled with CFR 0.152.
 */
package DE.siemens.ad.logo.model;

import CH.ifa.draw.util.StorableInput;
import CH.ifa.draw.util.StorableOutput;
import DE.siemens.ad.logo.model.Block;
import DE.siemens.ad.logo.model.NetworkParameter;
import DE.siemens.ad.logo.model.OutputParameter;
import java.io.IOException;

public class SOutputParameter
extends OutputParameter
implements NetworkParameter {
    private static final long serialVersionUID = -6944098975499523179L;
    protected String fSlaveAddress;
    protected int fBlockNumber;

    public SOutputParameter() {
        super(null);
    }

    public SOutputParameter(Block block) {
        super(block);
    }

    public String getAddress() {
        if (this.fSlaveAddress == null) {
            this.fSlaveAddress = "";
        }
        return this.fSlaveAddress;
    }

    public void setAddress(String slaveAddress) {
        this.fSlaveAddress = slaveAddress;
    }

    public int getConfiguredBlockNumber() {
        return this.fBlockNumber;
    }

    public void setConfiguredBlockNumber(int fOutputNumber) {
        this.fBlockNumber = fOutputNumber;
    }

    public String getConfiguredBlockPrefix() {
        return "Q";
    }

    public String getParameterText() {
        StringBuffer buffer = new StringBuffer(" \n");
        if (this.fSlaveAddress != null && this.fBlockNumber > 0) {
            buffer.append("Slave: " + this.fSlaveAddress + " \n");
            buffer.append("Output: " + this.getConfiguredBlockPrefix() + this.fBlockNumber);
        }
        return buffer.toString();
    }

    public void read(StorableInput dr) throws IOException {
        super.read(dr);
        this.setAddress(dr.readString());
        this.setConfiguredBlockNumber(dr.readInt());
    }

    public void write(StorableOutput dw) {
        super.write(dw);
        dw.writeString(this.fSlaveAddress);
        dw.writeInt(this.fBlockNumber);
    }

    public int getConfiguredBlockType() {
        return 7;
    }

    public boolean isForSlave() {
        return true;
    }

    public boolean isReadOP() {
        return false;
    }

    public void setConfiguredBlockType(int type) {
    }

    public void setForSlave(boolean value) {
    }
}

